; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F88
; Clock frequency: 20.0 MHz
;
;       The address of 'crc' (byte) (global) is 0x35
	crc EQU 0x35
;       The address of 'crc' (byte) (crcnibble) is 0x36
;       The address of 'x1' (byte) (global) is 0x37
	x1 EQU 0x37
;       The address of 'nibble' (byte) (crcnibble) is 0x38
;       The address of 'tmp' (word) (global) is 0x39
	tmp EQU 0x39
;       The address of 'crcnibble' (byte) (global) is 0x3B
	crcnibble EQU 0x3B
;       The address of 'channel' (byte) (global) is 0x3C
	channel EQU 0x3C
;       The address of 'tpacket' (array 5) (byte) (global) is 0x3D
	tpacket EQU 0x3D
;       The address of 'seed' (word) (random_number) is 0x42
;       The address of 'temp1' (byte) (global) is 0x44
	temp1 EQU 0x44
;       The address of 'temp2' (byte) (global) is 0x45
	temp2 EQU 0x45
;       The address of 'temp3' (byte) (global) is 0x46
	temp3 EQU 0x46
;       The address of 'humidity1' (byte) (global) is 0x47
	humidity1 EQU 0x47
;       The address of 'humidity2' (byte) (global) is 0x48
	humidity2 EQU 0x48
;       The address of 'txstate' (bit) (delay) is 0x49,0
;       The address of 'timer0_time' (byte) (delay) is 0x4A
;       The address of 'n' (byte) (global) is 0x4B
	n EQU 0x4B
;       The address of 'timer1_last' (word) (global) is 0x4C
	timer1_last EQU 0x4C
;       The address of 'tempsign' (byte) (global) is 0x4E
	tempsign EQU 0x4E
;       The address of 'hum' (word) (global) is 0x4F
	hum EQU 0x4F
;       The address of 'crc1calc' (byte) (global) is 0x51
	crc1calc EQU 0x51
;       The address of 'restart' (byte) (global) is 0x52
	restart EQU 0x52
;       The address of 'packet' (byte) (global) is 0x53
	packet EQU 0x53
;       The address of 'x2' (byte) (global) is 0x54
	x2 EQU 0x54
;       The address of 'tmp1' (byte) (global) is 0x55
	tmp1 EQU 0x55
;       The address of 'nibble' (byte) (global) is 0x56
	nibble EQU 0x56
;       The address of 'edata' (array 26) (byte) (global) is 0x57
	edata EQU 0x57
;       The address of 'channel_timing' (byte) (global) is 0x71
	channel_timing EQU 0x71
;       The address of 'rollingcode1' (byte) (global) is 0x72
	rollingcode1 EQU 0x72
;       The address of 'rollingcode2' (byte) (global) is 0x73
	rollingcode2 EQU 0x73
;       The address of 'battflag' (byte) (global) is 0x74
	battflag EQU 0x74
;       The address of 'x3' (byte) (global) is 0x75
	x3 EQU 0x75
;       The address of 'timer1_loops' (byte) (global) is 0x76
	timer1_loops EQU 0x76
;       The address of 'sensorid1' (byte) (global) is 0x77
	sensorid1 EQU 0x77
;       The address of 'sensorid2' (byte) (global) is 0x78
	sensorid2 EQU 0x78
;       The address of 'sensorid3' (byte) (global) is 0x79
	sensorid3 EQU 0x79
;       The address of 'sensorid4' (byte) (global) is 0x7A
	sensorid4 EQU 0x7A
;       The address of 'unknown' (byte) (global) is 0x7B
	unknown EQU 0x7B
;       The address of 'nextbit' (bit) (global) is 0x49,1
;       The address of 'looptimes' (byte) (random_number) is 0x7C
;       The address of 'packetbit' (byte) (global) is 0x7D
	packetbit EQU 0x7D
;       The address of 'bitno' (byte) (global) is 0x7E
	bitno EQU 0x7E
;       The address of 'dht_error' (bit) (global) is 0x49,2
;       The address of 'chksm' (byte) (global) is 0x7F
	chksm EQU 0x7F
;       The address of 'dht11' (bit) (global) is 0x49,3
;       The address of 'avcount' (word) (global) is 0xA0
	avcount EQU 0xA0
;       The address of 'flags' (byte) (global) is 0xA2
	flags EQU 0xA2
;       The address of 'syncflag' (byte) (global) is 0xA3
	syncflag EQU 0xA3
;       The address of 'timer1_left' (byte) (global) is 0xA4
	timer1_left EQU 0xA4
;       The address of 'nextnibble' (byte) (global) is 0xA5
	nextnibble EQU 0xA5
;       The address of 'crcpoly' (byte) (global) is 0xA6
	crcpoly EQU 0xA6
;       The address of 'crcnib1' (byte) (global) is 0xA7
	crcnib1 EQU 0xA7
;       The address of 'crcnib2' (byte) (global) is 0xA8
	crcnib2 EQU 0xA8
;       The address of 'crc1nib1' (byte) (global) is 0xA9
	crc1nib1 EQU 0xA9
;       The address of 'crc1nib2' (byte) (global) is 0xAA
	crc1nib2 EQU 0xAA
;       The address of 't1' (bit) (global) is 0x49,4
;       The address of 't2' (bit) (global) is 0x49,5
;       The address of 't3' (bit) (global) is 0x49,6
;       The address of 'v1' (byte) (global) is 0xAB
	v1 EQU 0xAB
;       The address of 'v2' (byte) (global) is 0xAC
	v2 EQU 0xAC
;       The address of 'v3' (byte) (global) is 0xAD
	v3 EQU 0xAD
;       The address of 'v4' (byte) (global) is 0xAE
	v4 EQU 0xAE
;       The address of 'v5' (byte) (global) is 0xAF
	v5 EQU 0xAF
;       The address of 'v6' (byte) (global) is 0xB0
	v6 EQU 0xB0
;       The address of 'v7' (byte) (global) is 0xB1
	v7 EQU 0xB1
;       The address of 'v8' (byte) (global) is 0xB2
	v8 EQU 0xB2
;       The address of 'avtemp' (byte) (averagetemp) is 0xB3
;       The address of 'random_number' (byte) (global) is 0xB4
	random_number EQU 0xB4
;       The address of 'avtemperature' (array 6) (byte) (global) is 0xB5
	avtemperature EQU 0xB5
;       The address of 'averagetemp' (word) (global) is 0xBB
	averagetemp EQU 0xBB
;       The address of 'timer1counter' (long) (global) is 0xBD
	timer1counter EQU 0xBD
;       The address of 'tx' (bit) (global) is 0x5,0
;       The address of 'led' (bit) (global) is 0x5,1
;       The address of 'dhtp' (bit) (global) is 0x85,3
;       The address of 'dht' (bit) (global) is 0x5,3
;       The address of 'dhtpower' (bit) (global) is 0x5,4
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	LONG_0 EQU 0x2C
	LONG_1 EQU 0x2D
	LONG_2 EQU 0x2E
	LONG_3 EQU 0x2F
	LONG2_0 EQU 0x30
	LONG2_1 EQU 0x31
	LONG2_2 EQU 0x32
	LONG2_3 EQU 0x33
	ARRARG_0 EQU 0x34
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,3
	GOTO L0015
	ORG 0x0004
	RETFIE
; LookUp Table: (0, 53, 59, 61, 67, 71, 79, 83, 87, 91, 93)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x00
	RETLW 0x35
	RETLW 0x3B
	RETLW 0x3D
	RETLW 0x43
	RETLW 0x47
	RETLW 0x4F
	RETLW 0x53
	RETLW 0x57
	RETLW 0x5B
	RETLW 0x5D
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word ShiftLeft Routine
SL01:	BCF STATUS,C
	RLF R0L,F
	RLF R0H,F
SL00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SL01
	RETURN
; Word ShiftRight Routine
SR01:	BCF STATUS,C
	RRF R0H,F
	RRF R0L,F
SR00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SR01
	RETURN
; Long Addition Routine
LA01:	MOVF R2L,W
	ADDWF R0L,F
	BTFSC STATUS,C
	CALL LA02
	MOVF R2H,W
	ADDWF R0H,F
	BTFSC STATUS,C
	CALL LA03
	MOVF R3L,W
	ADDWF R1L,F
	BTFSC STATUS,C
	CALL LA04
	MOVF R3H,W
	ADDWF R1H,F
	RETURN
LA02:	INCF R0H,F
	BTFSS STATUS,Z
	RETURN
LA03:	INCF R1L,F
	BTFSS STATUS,Z
	RETURN
LA04:	INCF R1H,F
	RETURN
; Long Subtraction Routine
LS01:
	CALL LS02
	CALL LA01
	RETURN
LS02:	COMF R2L,F
	COMF R2H,F
	COMF R3L,F
	COMF R3H,F
	INCF R2L,F
	BTFSS STATUS,Z
	RETURN
	INCF R2H,F
	BTFSS STATUS,Z
	RETURN
	INCF R3L,F
	BTFSS STATUS,Z
	RETURN
	INCF R3H,F
	RETURN
; Begin of program
L0015:
; 1: '10/09/2013
; 2: 'This code simulates an Oregon Scientific temperature sensor, type THGR810
; 3: 'This sensor measures temperature and humidity and trasnmits the data to an Oregon Base using
; 4: '433.92 Mhz
; 5: 'The data is sent in 4 bit nibbles using normal Manchester coding.
; 6: 'The data rate is 1024 Hz which equals Oregon V3 protocol.
; 7: 'The OS V3 protocol has assymetrical bit timings.
; 8: 'The RF message data layout is as follows.
; 9: 'A preamble of 6 nibbles consisting of all 1.
; 10: 'A sync nibble of 10.
; 11: 'Sensor data follows.
; 12: 
; 13: 
; 14: 'Sensor data is as follows.
; 15: 'Sensor ID - 4 nibbles, oregon THGR810 has ID of F824
; 16: 'Sensor rolling code  - 1 nibble
; 17: 'Sensor battery flag  - 1 nibble
; 18: 'Sensor temperature  - 3 nibbles format is xx.x deg
; 19: 'Sensor temperature sign - 1 nibble 0 is positive , non zero is negative.
; 20: 'Sensor humidity - 2 nibbles = xx%
; 21: '1 nibble next of which purpose is unknown.****
; 22: 'Sensor CRC which is simply arithmetical sum of data from Sensor data to above data ****
; 23: 'Sensor post amble - 2 nibbles CCitt7 CRC.
; 24: 'Nibbles are sent in order with the LSB of each nibble sent first.
; 25: 'Sensor code for THGR810 sensor is F824.
; 26: 'The transmit time of this sensor depends on what channel its set too'
; 27: 'Times are
; 28: '1   2   3   4   5   6   7   8   9   10   Channel number
; 29: '53  59  61  67  71  79  83  87  91  93   Time in seconds
; 30: 'Transmission times are crystalled controlled and accurate down to 100 us.
; 31: 
; 32: 
; 33: 
; 34: 
; 35: 
; 36: 'Notes on the DHT22 temp Sensor.
; 37: 'This Sensor sends 5 bytes of data which are RH1-RH2, Temp1-Temp2, crc
; 38: 'Rh1-Rh2 is a 16 bit word that is divided by 10 to read XX.X %
; 39: 'Temp1-Temp2 is a 16 bit word that is divided by 10 to read XX.X D
; 40: 'If the MSB of Temp1 is 1 , the temp is -, ie below 0D C.
; 41: 'The CRC is the 8 bit sum the 4 data bytes.
; 42: 
; 43: 'Notes on the DHT11 Temp Sensor.
; 44: 'This sensor sends data in the same way as the DHT22, but the data format is differant.
; 45: 'First byte = RH in decimal, this sensor doesnt send a fractional part, so the 2nd byte
; 46: 'is always 0.
; 47: 'Third byte = Temp in Decimal, again no fractional part , so byte 4 is always = 0.
; 48: 'Some simple averaging is applied to the DHT11 sensor to make the temp readings look a bit better.
; 49: 'The first 5 temp readings from the DHT11 Sensor should be ignored.
; 50: 
; 51: 'To conserve battery power As much As possible the power to the Sensor is turned off when its not being read.
; 52: 'To give the Sensor time to stabilise, power is turned on 6 seconds before a read is taken.
; 53: 'This mainly for the DHT11 sensor which seems to be a bit power hungry, draws around 150 ua in idle mode.
; 54: 'The DHT22 is better and only draws 40 ua in idle mode.
; 55: 
; 56: 'Notes on the OS console.
; 57: 'The OS Console has a gated receiver which is turned off most of the time.
; 58: 'It only gets turned on when the console is expecting a sensor to transmit.
; 59: 'Initialyy when the OS console is reset, the receiver is turned on all the time for around 5 minutes and in this time will receive any sensor
; 60: 'it hears.
; 61: 'After the 5 minutes are up the receiver then gets turned on and off at various times depending on how many sensors and what channel they are on
; 62: 'it has heard in the first 5 minutes.
; 63: 'The Console receiver is on for a very short time , around 750 ms , so the sensors must transmit at exactly the right time.
; 64: 'There appears to be some capacity for the Console to track each sensor if its transmission time wanders, but how far it can be off I
; 65: 'havnt been able to determine.
; 66: 'OS THGR810 sensors have a 32.768 watch crystal in them to determine timings, so this code also uses a 32.768 crystal to do the same.
; 67: 'Notes on Data timing.
; 68: 'The OS console is quite critical in terms of data timings.
; 69: 'From my investigations , the data pulses need to be within 15 us of what the OS console expects otherwise the transmission is ignored.
; 70: 'To make things worse, the receiver in the OS console seems to modify the incoming data transmission so that the pulse widths are slightly altered
; 71: 'from what is being transmitted.
; 72: 'On or hi pulses get lengthened and lo or off pulses get shortened.
; 73: 'This means that the data timing for the transmitter has to be altered to make the data timing for the console look right.
; 74: 'Why they do this and why the data timing is so critical I have no idea.
; 75: 'To get the timing right its necessary to use the inbuilt timers in the Micro to generate the data timings.
; 76: 'Timer0 is used to time the data pulses.
; 77: 'The original idea of just using wait statements which works Ok for WSDL just wont work for the OS console.
; 78: 'Ive tried this code on WMR100 and WMR80 consoles and both appear to work OK.
; 79: '10/09/2013 fixed bug where correct sensor wasnt being detected properly.
; 80: 
; 81: 
; 82: 
; 83: 
; 84: AllDigital
	BSF STATUS,RP0
	CLRF 0x1B
	MOVLW 0x07
	MOVWF 0x1C
	BCF STATUS,RP0
; 85: Define CLOCK_FREQUENCY = 20  'Crystal frequency.
; 86: 
; 87: 
; 88: 
; 89: 
; 90: 
; 91: 
; 92: Dim x1 As Byte
; 93: Dim x2 As Byte
; 94: Dim x3 As Byte
; 95: Dim flags As Byte
; 96: Dim syncflag As Byte
; 97: Dim channel As Byte
; 98: Dim channel_timing As Byte
; 99: Dim timer1_loops As Byte
; 100: Dim timer1_left As Byte
; 101: Dim timer1_last As Word
; 102: Dim rollingcode1 As Byte
; 103: Dim rollingcode2 As Byte
; 104: Dim battflag As Byte
; 105: Dim temp1 As Byte
; 106: Dim temp2 As Byte
; 107: Dim temp3 As Byte
; 108: Dim tempsign As Byte
; 109: Dim humidity1 As Byte
; 110: Dim humidity2 As Byte
; 111: Dim sensorid1 As Byte
; 112: Dim sensorid2 As Byte
; 113: Dim sensorid3 As Byte
; 114: Dim sensorid4 As Byte
; 115: Dim unknown As Byte
; 116: Dim crc As Byte
; 117: Dim hum As Word
; 118: Dim tmp As Word
; 119: Dim tmp1 As Byte
; 120: Dim packetbit As Byte
; 121: Dim nibble As Byte
; 122: Dim nextnibble As Byte
; 123: Dim nextbit As Bit
; 124: 
; 125: Dim timer1counter As Long
; 126: 
; 127: 'variables for the CRC calculations.
; 128: Dim bitno As Byte
; 129: Dim crcpoly As Byte
; 130: Dim crcnib1 As Byte
; 131: Dim crcnib2 As Byte
; 132: Dim crc1nib1 As Byte
; 133: Dim crc1nib2 As Byte
; 134: Dim crc1calc As Byte
; 135: 
; 136: 'variables for the random number generator.
; 137: Dim t1 As Bit
; 138: Dim t2 As Bit
; 139: Dim t3 As Bit
; 140: Dim restart As Byte
; 141: 
; 142: 
; 143: 
; 144: 
; 145: 'DHT Sensor variables.
; 146: Dim dht_error As Bit
; 147: Dim tpacket(5) As Byte
; 148: Dim packet As Byte
; 149: Dim chksm As Byte
; 150: Dim dht11 As Bit
; 151: Dim n As Byte
; 152: Dim avtemperature(6) As Byte
; 153: Dim avcount As Word
; 154: 
; 155: 'variables for data transmit code.
; 156: Dim v1 As Byte
; 157: Dim v2 As Byte
; 158: Dim v3 As Byte
; 159: Dim v4 As Byte
; 160: Dim v5 As Byte
; 161: Dim v6 As Byte
; 162: Dim v7 As Byte
; 163: Dim v8 As Byte
; 164: 
; 165: 
; 166: For n = 0 To 5  'Load DHT11 Temperature averaging array with 0, only needed for 1st 5 minutes.
	CLRF 0x4B
L0016:
	MOVF 0x4B,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0017
; 167: 	avtemperature(n) = 0
	MOVF 0x4B,W
	ADDLW 0xB5
	MOVWF FSR
	CLRF INDF
; 168: Next n
	MOVLW 0x01
	ADDWF 0x4B,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0016
L0017:
; 169: 
; 170: crcpoly = 7  'Polynomial for CCITT-8 CRC
	MOVLW 0x07
	BSF STATUS,RP0
	MOVWF 0x26
	BCF STATUS,RP0
; 171: crc = 0  'this is the initial value used by all OS version 3.0 sensors
	CLRF 0x35
; 172: 
; 173: 
; 174: dht11 = 0  'Set to 1 for DHT11, set to 0 for DHT22.
	BCF 0x49,3
; 175: TRISA = 0  'All bits op to save power during sleep mode.
	BSF STATUS,RP0
	CLRF 0x05
; 176: TRISB = 0  'All bite op to save power during sleep mode.
	CLRF 0x06
	BCF STATUS,RP0
; 177: PORTA = 0  'Set all ports to output
	CLRF 0x05
; 178: PORTB = 0
	CLRF 0x06
; 179: 
; 180: Symbol tx = PORTA.0  'Pin transmitter is connected too.
; 181: Symbol led = PORTA.1  'Activity led.
; 182: Symbol dhtp = TRISA.3  'this pin needs to be bidirectional
; 183: Symbol dht = PORTA.3  'Sensor data pin.
; 184: Symbol dhtpower = PORTA.4  'Sensor Vcc pin.
; 185: dhtp = 1  'initially set this port to input.Normal state when not reading DHT Sensor.
	BSF STATUS,RP0
	BSF 0x05,3
	BCF STATUS,RP0
; 186: tx = 0  'Transmitter off
	BCF 0x05,0
; 187: 
; 188: 
; 189: 
; 190: 
; 191: 
; 192: 
; 193: Dim edata(26) As Byte  'array variables 0 - 25 + 1 dummy variable so that the Manchester coding routine works properly.
; 194: 
; 195: 
; 196: 
; 197: 'Some of the following values get changed later after the sensor is read.
; 198: flags = 15
	MOVLW 0x0F
	BSF STATUS,RP0
	MOVWF 0x22
	BCF STATUS,RP0
; 199: syncflag = 10
	MOVLW 0x0A
	BSF STATUS,RP0
	MOVWF 0x23
	BCF STATUS,RP0
; 200: sensorid1 = 0xf  'nibble 0
	MOVLW 0x0F
	MOVWF 0x77
; 201: sensorid2 = 0x8  'nibble 1
	MOVLW 0x08
	MOVWF 0x78
; 202: sensorid3 = 0x2  'nibble 2
	MOVLW 0x02
	MOVWF 0x79
; 203: sensorid4 = 0x4  'nibble 3
	MOVLW 0x04
	MOVWF 0x7A
; 204: channel = 2  'nibble 4 (THGR810 can use channels 1 to 10, but 1 is normally reserved by outside temp sensor.)
	MOVLW 0x02
	MOVWF 0x3C
; 205: rollingcode1 = 0xb  'nibble 5
	MOVLW 0x0B
	MOVWF 0x72
; 206: rollingcode2 = 0xd  'nibble 6
	MOVLW 0x0D
	MOVWF 0x73
; 207: battflag = 8  'nibble 7
	MOVLW 0x08
	MOVWF 0x74
; 208: temp1 = 8  'nibble 8 'Temp=23.8
	MOVLW 0x08
	MOVWF 0x44
; 209: temp2 = 3  'nibble 9
	MOVLW 0x03
	MOVWF 0x45
; 210: temp3 = 2  'nibble 10
	MOVLW 0x02
	MOVWF 0x46
; 211: tempsign = 0  'nibble 11 0 for positive value, non zero for negative value
	CLRF 0x4E
; 212: humidity1 = 3  'nibble 12 28%
	MOVLW 0x03
	MOVWF 0x47
; 213: humidity2 = 5  'nibble 13
	MOVLW 0x05
	MOVWF 0x48
; 214: unknown = 4  'nibble 14 not known what this data is for.
	MOVLW 0x04
	MOVWF 0x7B
; 215: timer1counter = 65536
	BSF STATUS,RP0
	CLRF 0x3D
	CLRF 0x3E
	MOVLW 0x01
	MOVWF 0x3F
	CLRF 0x40
	BCF STATUS,RP0
; 216: 
; 217: 'Transmit Data timing values, based on 20 Mhz Crystal.
; 218: 'Delay time = (256 - v) * 3.2 us
; 219: v1 = 119
	MOVLW 0x77
	BSF STATUS,RP0
	MOVWF 0x2B
	BCF STATUS,RP0
; 220: v2 = 89
	MOVLW 0x59
	BSF STATUS,RP0
	MOVWF 0x2C
	BCF STATUS,RP0
; 221: v3 = 119
	MOVLW 0x77
	BSF STATUS,RP0
	MOVWF 0x2D
	BCF STATUS,RP0
; 222: v4 = 117
	MOVLW 0x75
	BSF STATUS,RP0
	MOVWF 0x2E
	BCF STATUS,RP0
; 223: v5 = 90
	MOVLW 0x5A
	BSF STATUS,RP0
	MOVWF 0x2F
	BCF STATUS,RP0
; 224: v6 = 96
	MOVLW 0x60
	BSF STATUS,RP0
	MOVWF 0x30
	BCF STATUS,RP0
; 225: v7 = 89
	MOVLW 0x59
	BSF STATUS,RP0
	MOVWF 0x31
	BCF STATUS,RP0
; 226: v8 = 116
	MOVLW 0x74
	BSF STATUS,RP0
	MOVWF 0x32
	BCF STATUS,RP0
; 227: 
; 228: 
; 229: 
; 230: T1CON.T1OSCEN = 1  'Turn on the Timer1 external clock oscillator.This is the watch crystal, a very low power oscillator.
	BSF 0x10,3
; 231: T1CON.TMR1CS = 1  'Set clock oscillator as Timer1 Clocking source.
	BSF 0x10,1
; 232: T1CON.2 = 1  'Disable Timer1 clock sync , needed to keep Timer1 running while Micro is asleep.
	BSF 0x10,2
; 233: T1CON.TMR1ON = 0  'Initially stop Timer1
	BCF 0x10,0
; 234: T1CON.T1CKPS1 = 1  'Timer1 prescaler set to 8, gives 4096 ticks per second
	BSF 0x10,5
; 235: T1CON.T1CKPS0 = 1  'Timer1 prescaler set to 8
	BSF 0x10,4
; 236: PIE1.TMR1IE = 1  'Enable Timer1 overflow flag,needed tp wake up the Micro from sleep.
	BSF STATUS,RP0
	BSF 0x0C,0
	BCF STATUS,RP0
; 237: INTCON.PEIE = 1  'Generate interrupt on Timer1 overflow.No actual interrupt ie, vector to 0x0004 occurs, as GIE bit is not set.
	BSF 0x0B,6
; 238: 'but is needed  To wake up the micro from sleep.
; 239: CMCON.CM2 = 1  'Turn off Comparators to reduce power consumption when sleeping.
	BSF STATUS,RP0
	BSF 0x1C,2
; 240: CMCON.CM1 = 1  '-
	BSF 0x1C,1
; 241: CMCON.CM0 = 1  '-
	BSF 0x1C,0
; 242: 
; 243: OPTION_REG.PSA = 0  'set TMR0 prescaler to timet 0
	BCF 0x01,3
; 244: OPTION_REG.PS2 = 0  'above
	BCF 0x01,2
; 245: OPTION_REG.PS1 = 1  'above
	BSF 0x01,1
; 246: 
; 247: 
; 248: 
; 249: 
; 250: 
; 251: 
; 252: 
; 253: 
; 254: OPTION_REG.PS0 = 1  'Set TMR0 prescaler to 16,as we need to count in approx 3 us ticks for the DHT Sensor and the Transmit code, this gives 3.2 us ticks.
	BSF 0x01,0
; 255: OPTION_REG.T0CS = 0  'enable tmr0
	BCF 0x01,5
	BCF STATUS,RP0
; 256: 
; 257: 'Hseropen 19200
; 258: 
; 259: 
; 260: 
; 261: led = 1  'Light the led to show something is happening.
	BSF 0x05,1
; 262: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 263: led = 0  'Turn the led off.
	BCF 0x05,1
; 264: 'Read the channel number and Sensor type.
; 265: TRISB.0 = 1  'Set bits 0 - 4 of Ch B to inputs
	BSF STATUS,RP0
	BSF 0x06,0
; 266: TRISB.1 = 1  'Read the channel no and the DHT type.
	BSF 0x06,1
; 267: TRISB.2 = 1
	BSF 0x06,2
; 268: TRISB.3 = 1
	BSF 0x06,3
; 269: 
; 270: 
; 271: TRISB.4 = 1  'This bit is for sensor type , 1 = dht11, 0 = dht22
	BSF 0x06,4
; 272: 
; 273: OPTION_REG.7 = 0  'weak pull ups on.Turns on CHB weak pullups.Link in = 0 , Link out = 1.
	BCF 0x01,7
	BCF STATUS,RP0
; 274: 
; 275: channel = PORTB And 15  'Read portb 0 - 3
	MOVF 0x06,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x3C
; 276: channel = channel + 1  'Channels can be 1 to 10, 1  is reserved for outdoor type temp sensors.
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 277: If channel > 10 Then channel = 10
	MOVF 0x3C,W
	SUBLW 0x0A
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0018
	MOVLW 0x0A
	MOVWF 0x3C
L0018:
; 278: dht11 = PORTB.4  '0 = dht22, 1 = dht11
	BTFSC 0x06,4
	BSF 0x49,3
	BTFSS 0x06,4
	BCF 0x49,3
; 279: TRISB = 0  'Set PORTB to output, turns off weak pullups.
	BSF STATUS,RP0
	CLRF 0x06
	BCF STATUS,RP0
; 280: 
; 281: 
; 282: For x1 = 1 To channel  'Flash the led to indicate we have started.One flash per channel number.
	MOVLW 0x01
	MOVWF 0x37
L0019:
	MOVF 0x37,W
	SUBWF 0x3C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0020
; 283: 	WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 284: 	led = 1
	BSF 0x05,1
; 285: 	WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 286: 	led = 0
	BCF 0x05,1
; 287: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0019
L0020:
; 288: 
; 289: 
; 290: 
; 291: 'Simple lookup table, channel_timing returns the channel  value in the table, ie channel = 3 , channel _value = 3rd value starting at 0 ,= 61
; 292: channel_timing = LookUp(0, 53, 59, 61, 67, 71, 79, 83, 87, 91, 93), channel  'Periodic Transmission times for each channel in seconds.
	MOVF 0x3C,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0021
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x71
L0021:
; 293: 
; 294: 'Generate a random number for the rollingcode.
; 295: 'To make the random number , read the DHT Sensor and multiply the RH by the temp to get the seed for the RNG.
; 296: 'To make it a bit more random , run the RNG generator multiple times based on the channel number and the number of times
; 297: 'the batteries have been replaced, this value held in EEPROM and incremented every time the Micro is restarted.
; 298: dhtpower = 1
	BSF 0x05,4
; 299: WaitMs 6000  'allow Sensor to stabilise.
	MOVLW 0x70
	MOVWF R0L
	MOVLW 0x17
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 300: Gosub read_dht  'read the temperature and humidity.
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 301: tmp = temp3 + temp2 + temp1
	MOVF 0x46,W
	ADDWF 0x45,W
	MOVWF 0x39
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x39,W
	ADDWF 0x44,W
	MOVWF 0x39
	MOVF 0x3A,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3A
; 302: tmp1 = humidity2 + humidity1
	MOVF 0x48,W
	ADDWF 0x47,W
	MOVWF 0x55
; 303: tmp = tmp * tmp1
	MOVF 0x39,W
	MOVWF R3L
	MOVF 0x3A,W
	MOVWF R3H
	MOVF 0x55,W
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x39
	MOVF R2H,W
	MOVWF 0x3A
; 304: Read 1, restart  'Read location 1 in the EEprom.
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x52
; 305: If restart = 255 Then restart = 0  'Reset to 0 if EEprom value overflows , probably happens anyway.
	MOVF 0x52,W
	SUBLW 0xFF
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0022
	CLRF 0x52
L0022:
; 306: restart = restart + 1  'Increment restart value.
	MOVF 0x52,W
	ADDLW 0x01
	MOVWF 0x52
; 307: Write 1, restart  'write new value back to EEprom.
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x52,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0023:	BTFSC EECON1,WR
	GOTO L0023
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 308: tmp1 = restart + channel
	MOVF 0x52,W
	ADDWF 0x3C,W
	MOVWF 0x55
; 309: x1 = random_number(tmp, tmp1)  'generate the random number.
;       The address of 'oshonsoft_temp_1' (word) (global) is 0xC1
	oshonsoft_temp_1 EQU 0xC1
	MOVF 0x39,W
	MOVWF 0x42
	MOVF 0x3A,W
	MOVWF 0x43
	MOVF 0x55,W
	MOVWF 0x7C
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0014
	BSF STATUS,RP0
	MOVF 0x34,W
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x37
; 310: rollingcode1 = ShiftRight(x1, 4)
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	CALL SR00
	MOVF R0L,W
	MOVWF 0x72
; 311: rollingcode2 = x1 And 15
	MOVF 0x37,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x73
; 312: 
; 313: 
; 314: 
; 315: 
; 316: 'Calculate Timer1 values.
; 317: 'Notes. timer1 is a 16 bit timer and we use the overflow flag which goes high when Timer1 goes from 0xFFFF to 0x0000.
; 318: 'We must transmit data at exactly the right times or the OS console wont receive it.
; 319: 'To conserve battery power in the Sensor the CPU and the DHT Sensors must be kept in sleep mode as much as possible.
; 320: 'To keep time whilst the CPU is asleep , Timer1 runs off a 32.768 Khz watch crystal which keeps running all the time.
; 321: 'The Timer1 prescaler is set to 8 , which with Timer1 being a 16 bit Timer, gives a timing range of 16 seconds.
; 322: 'As the transmission intervals are greater than 16 seconds, we must count timer1 counts multiple times.
; 323: 'Timer1_loops sets how many times we must count for 16 seconds, and timer1_last sets how long the last count is , which is always less
; 324: 'than 16 seconds.
; 325: 'Timer1 takes 16 seconds to overflow , ie 4096 counts per second, so preloaded value into Timer1 = 65536 - (timer1_left * 4096)
; 326: 'The power to the DHT Sensor must be turned on at least 6 seconds before we try to read data.
; 327: 'So the timing routine must allow for the 6 seconds needed to power up the DHT Sensor.
; 328: channel_timing = channel_timing - 6  'Reduce initial wait time by 6 seconds to allow for Sensor on time.
	MOVLW 0x06
	SUBWF 0x71,W
	MOVWF 0x71
; 329: timer1_loops = channel_timing / 16  'numcer of timer to count to 16
	MOVF 0x71,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x76
; 330: timer1_left = channel_timing Mod 16  'whats left
	MOVF 0x71,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x24
; 331: timer1_last = (timer1counter - (timer1_left * 4096)) / 256  'Timer1 is preloaded with this vzlue
	MOVF 0x24,W
	BCF STATUS,RP0
	MOVWF R3L
	CLRF R3H
	CLRF R1L
	MOVLW 0x10
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x4C
	MOVF R2H,W
	MOVWF 0x4D
;       The address of 'oshonsoft_temp_2' (long) (global) is 0xC3
	oshonsoft_temp_2 EQU 0xC3
	BSF STATUS,RP0
	MOVF 0x3D,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x3E,W
	BCF STATUS,RP0
	MOVWF R0H
	BSF STATUS,RP0
	MOVF 0x3F,W
	BCF STATUS,RP0
	MOVWF R1L
	BSF STATUS,RP0
	MOVF 0x40,W
	BCF STATUS,RP0
	MOVWF R1H
	MOVF 0x4C,W
	MOVWF R2L
	MOVF 0x4D,W
	MOVWF R2H
	CLRF R3L
	CLRF R3H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL LS01
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x43
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x44
	BCF STATUS,RP0
	MOVF R1L,W
	BSF STATUS,RP0
	MOVWF 0x45
	BCF STATUS,RP0
	MOVF R1H,W
	BSF STATUS,RP0
	MOVWF 0x46
	MOVF 0x43,W
	BCF STATUS,RP0
	MOVWF 0x4C
	BSF STATUS,RP0
	MOVF 0x44,W
	BCF STATUS,RP0
	MOVWF 0x4D
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0x01
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4C
	MOVF R0H,W
	MOVWF 0x4D
; 332: 
; 333: 
; 334: 'Datasheet recommends setting low byte of timer1 to 0, b4 loading hi byte, then load lo byte.
; 335: T1CON.TMR1ON = 0  'Preload Timer1 with 0
	BCF 0x10,0
; 336: TMR1L = 0
	CLRF 0x0E
; 337: TMR1H = 0
	CLRF 0x0F
; 338: TMR1L = 0
	CLRF 0x0E
; 339: T1CON.TMR1ON = 1  'Start Timer1
	BSF 0x10,0
; 340: 
; 341: start:  'Main Loop.
L0001:
; 342: 
; 343: 'This code here sets the transmission timing for each channel.
; 344: 'The Timer1 overflow interrupt must be disabled immediately after sleep, and re enabled after the overflow flag has been cleared.
; 345: '-----------------------------------------------------------------
; 346: For x1 = 1 To timer1_loops  'This loop counts 16 second sleep times.
	MOVLW 0x01
	MOVWF 0x37
L0024:
	MOVF 0x37,W
	SUBWF 0x76,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0025
; 347: 	ASM:        sleep  'sleeps the Micro to reduce battery drain.
	sleep
; 348: 	PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
	BSF STATUS,RP0
	BCF 0x0C,0
	BCF STATUS,RP0
; 349: 	PIR1.TMR1IF = 0  'clear Timer1 overflow flag
	BCF 0x0C,0
; 350: 	PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
	BSF STATUS,RP0
	BSF 0x0C,0
	BCF STATUS,RP0
; 351: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0024
L0025:
; 352: 
; 353: PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt.
	BSF STATUS,RP0
	BCF 0x0C,0
	BCF STATUS,RP0
; 354: T1CON.TMR1ON = 0  'stop timer1, needs to be stopped to preload new values.
	BCF 0x10,0
; 355: TMR1L = 0
	CLRF 0x0E
; 356: TMR1H = timer1_last  'load Timer1 with remaining time count.This counts the remainder of the sleep time.
	MOVF 0x4C,W
	MOVWF 0x0F
; 357: TMR1L = 0
	CLRF 0x0E
; 358: T1CON.TMR1ON = 1  'start timer1
	BSF 0x10,0
; 359: PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
	BSF STATUS,RP0
	BSF 0x0C,0
	BCF STATUS,RP0
; 360: ASM:        sleep
	sleep
; 361: 
; 362: PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
	BSF STATUS,RP0
	BCF 0x0C,0
	BCF STATUS,RP0
; 363: PIR1.TMR1IF = 0  'clear Timer1 overflow flag
	BCF 0x0C,0
; 364: T1CON.TMR1ON = 0  'Stop timer1
	BCF 0x10,0
; 365: TMR1L = 0
	CLRF 0x0E
; 366: TMR1H = 160  'Preload Timer1 with 6 seconds .(65536 - (4096 * 6))/256
	MOVLW 0xA0
	MOVWF 0x0F
; 367: TMR1L = 0
	CLRF 0x0E
; 368: dhtpower = 1  'turn on the Sensor power.
	BSF 0x05,4
; 369: T1CON.TMR1ON = 1  'start timer1
	BSF 0x10,0
; 370: PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
	BSF STATUS,RP0
	BSF 0x0C,0
	BCF STATUS,RP0
; 371: 
; 372: ASM:        sleep  'We sleep for 6 seconds to allow the Sensor to stabilse.
	sleep
; 373: PIE1.TMR1IE = 0  'disable Timer1 overflow interrupt
	BSF STATUS,RP0
	BCF 0x0C,0
	BCF STATUS,RP0
; 374: PIR1.TMR1IF = 0  'clear Timer1 overflow flag
	BCF 0x0C,0
; 375: PIE1.TMR1IE = 1  'enable Timer1 overflow interrupt.
	BSF STATUS,RP0
	BSF 0x0C,0
	BCF STATUS,RP0
; 376: 
; 377: 
; 378: '--------------------------------------------------------------------
; 379: 
; 380: Gosub read_dht  'Read the Temp / Hum data.
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 381: 
; 382: transmit:  'Here we load the data array and Transmit the data.
L0002:
; 383: For x1 = 0 To 5  'Store flags in array.
	CLRF 0x37
L0026:
	MOVF 0x37,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0027
; 384: edata(x1) = flags
	MOVF 0x37,W
	ADDLW 0x57
	MOVWF FSR
	BSF STATUS,RP0
	MOVF 0x22,W
	MOVWF INDF
	BCF STATUS,RP0
; 385: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0026
L0027:
; 386: 
; 387: 
; 388: edata(6) = syncflag  'Store Syncflag in Array
	BSF STATUS,RP0
	MOVF 0x23,W
	BCF STATUS,RP0
	MOVWF 0x5D
; 389: 
; 390: edata(7) = sensorid1  'Store sensor ID
	MOVF 0x77,W
	MOVWF 0x5E
; 391: edata(8) = sensorid2
	MOVF 0x78,W
	MOVWF 0x5F
; 392: edata(9) = sensorid3
	MOVF 0x79,W
	MOVWF 0x60
; 393: edata(10) = sensorid4
	MOVF 0x7A,W
	MOVWF 0x61
; 394: 
; 395: edata(11) = channel  'Sensor Channel
	MOVF 0x3C,W
	MOVWF 0x62
; 396: 
; 397: edata(12) = rollingcode1  'sensor rolling code
	MOVF 0x72,W
	MOVWF 0x63
; 398: edata(13) = rollingcode2
	MOVF 0x73,W
	MOVWF 0x64
; 399: 
; 400: edata(14) = battflag  'Battery flag
	MOVF 0x74,W
	MOVWF 0x65
; 401: 
; 402: edata(15) = temp1  'Send temperature LSB first
	MOVF 0x44,W
	MOVWF 0x66
; 403: edata(16) = temp2
	MOVF 0x45,W
	MOVWF 0x67
; 404: edata(17) = temp3
	MOVF 0x46,W
	MOVWF 0x68
; 405: edata(18) = tempsign  '0=Indicates a positive temp,1= negative
	MOVF 0x4E,W
	MOVWF 0x69
; 406: 
; 407: edata(19) = humidity1  'send humidity. LSB first
	MOVF 0x47,W
	MOVWF 0x6A
; 408: edata(20) = humidity2
	MOVF 0x48,W
	MOVWF 0x6B
; 409: edata(21) = unknown
	MOVF 0x7B,W
	MOVWF 0x6C
; 410: 
; 411: Gosub calc_crc1  'Calculate the first crc.
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0013
; 412: edata(22) = crc1nib1  '1st normal modulo8 CRC.
	BSF STATUS,RP0
	MOVF 0x29,W
	BCF STATUS,RP0
	MOVWF 0x6D
; 413: edata(23) = crc1nib2
	BSF STATUS,RP0
	MOVF 0x2A,W
	BCF STATUS,RP0
	MOVWF 0x6E
; 414: 
; 415: Gosub crc2calc  'calculate the 2nd CRC
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0011
; 416: edata(24) = crcnib1  'End 2nd crc.
	BSF STATUS,RP0
	MOVF 0x27,W
	BCF STATUS,RP0
	MOVWF 0x6F
; 417: edata(25) = crcnib2
	BSF STATUS,RP0
	MOVF 0x28,W
	BCF STATUS,RP0
	MOVWF 0x70
; 418: edata(26) = 0  'dummy data to allow the nibble look ahead to work properly.
	CLRF 0x71
; 419: 
; 420: 'We start transmitting here.
; 421: led = 1  'Light the Led
	BSF 0x05,1
; 422: WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 423: INTCON.TMR0IF = 1  'This routine user TMR0 to do the data timing.
	BSF 0x0B,2
; 424: 'This routine encodes a 4 bit nibble into Manchester format.
; 425: 'Due to the odd timings that OS3 sensors use, its necessary to look at what the next bit is when encoding the current bit.
; 426: For x1 = 0 To 25  '26 variables to send.
	CLRF 0x37
L0028:
	MOVF 0x37,W
	SUBLW 0x19
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0029
; 427: 	nibble = edata(x1)
	MOVF 0x37,W
	ADDLW 0x57
	MOVWF FSR
	MOVF INDF,W
	MOVWF 0x56
; 428: 		For x2 = 0 To 3  '4 bits per nibble to send.We need to look ahead to the next nibble when the current nibble bit is MSB.
	CLRF 0x54
L0030:
	MOVF 0x54,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0031
; 429: 				If x2 = 3 Then
	MOVF 0x54,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0032
; 430: 					x3 = x1 + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x75
; 431: 					nextnibble = edata(x3)  'need To look at Next Bit when sending current bit
	MOVF 0x75,W
	ADDLW 0x57
	MOVWF FSR
	MOVF INDF,W
	BSF STATUS,RP0
	MOVWF 0x25
	BCF STATUS,RP0
; 432: 					nextbit = nextnibble.0  'next bit is either in current nibble , or is in next nibble.
	CLRW
	BSF STATUS,RP0
	BTFSC 0x25,0
	ADDLW 0x01
	BCF STATUS,RP0
	BTFSC STATUS,Z
	BCF 0x49,1
	BTFSS STATUS,Z
	BSF 0x49,1
; 433: 				Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0033
L0032:
; 434: 					nextbit = nibble.1
	BTFSC 0x56,1
	BSF 0x49,1
	BTFSS 0x56,1
	BCF 0x49,1
; 435: 				Endif
L0033:
; 436: 'This is the bit that does the hard work.
; 437: 'Dont fool with the delay times , unless you really know what you are doing.
; 438: 		If nibble.0 = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x56,0
	GOTO L0034
; 439: 					'1 followed by 1  short hi - short lo
; 440: 				If nextbit = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x49,1
	GOTO L0035
; 441: 					Call delay(1, v1)  'wait 438
	BSF 0x49,0
	BSF STATUS,RP0
	MOVF 0x2B,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 442: 					Call delay(0, v2)  'wait 534
	BCF 0x49,0
	BSF STATUS,RP0
	MOVF 0x2C,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 443: 				Else  '1 followed by 0 Long Lo  - short hi - long lo
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0036
L0035:
; 444: 					Call delay(1, v3)  'wait 438 us
	BSF 0x49,0
	BSF STATUS,RP0
	MOVF 0x2D,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 445: 					Call delay(0, v4)  'wait 444 us
	BCF 0x49,0
	BSF STATUS,RP0
	MOVF 0x2E,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 446: 				Endif
L0036:
; 447: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0034:
; 448: 				
; 449: 			If nextbit = 1 Then  '0 followed by 1 ,Long Hi   short lo - long hi
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x49,1
	GOTO L0038
; 450: 				Call delay(0, v5)  'wait 531
	BCF 0x49,0
	BSF STATUS,RP0
	MOVF 0x2F,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 451: 				Call delay(1, v6)  'wait 512 us
	BSF 0x49,0
	BSF STATUS,RP0
	MOVF 0x30,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 452: 			Else  ''0 followed by 0   short lo - short hi
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0039
L0038:
; 453: 				Call delay(0, v7)  'wait 534 us
	BCF 0x49,0
	BSF STATUS,RP0
	MOVF 0x31,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 454: 				Call delay(1, v8)  'wait 448 us
	BSF 0x49,0
	BSF STATUS,RP0
	MOVF 0x32,W
	BCF STATUS,RP0
	MOVWF 0x4A
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 455: 			Endif
L0039:
; 456: 		Endif
L0037:
; 457: 		nibble = ShiftRight(nibble, 1)  'Shift nibble one bit right to get next bit.
	MOVF 0x56,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	CALL SR00
	MOVF R0L,W
	MOVWF 0x56
; 458: 	Next x2
	MOVLW 0x01
	ADDWF 0x54,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0030
L0031:
; 459: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0028
L0029:
; 460: tx = 0
	BCF 0x05,0
; 461: led = 0
	BCF 0x05,1
; 462: Goto start
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0001
; 463: 
; 464: End
;       PAGE SELECT
;	BCF PCLATH,3
L0040:	GOTO L0040
; 465: 'This process times the data pulses.
; 466: 'We enter with timer0 preloaded with a value and counting up at 1 tick every 3.2 us.
; 467: 'The Timer0 overflow flag will normally be 0 and gets set to 1 when the timer overflows from 0xFF to 0x00.
; 468: 'The OS console has tight data timing requirements and using simple wait statements makes the process unreliable.
; 469: 
; 470: Proc delay(txstate As Bit, timer0_time As Byte)  'user Timer0 to generate the data pulses.
L0003:
; 471: While INTCON.TMR0IF = 0  'wait for Timer0 to overflow
L0041:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x0B,2
	GOTO L0042
; 472: Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0041
L0042:
; 473: INTCON.TMR0IF = 0  'clear the overflow flag
	BCF 0x0B,2
; 474: tx = txstate  'set the transmitter state
	BTFSC 0x49,0
	BSF 0x05,0
	BTFSS 0x49,0
	BCF 0x05,0
; 475: TMR0 = timer0_time  'load the timer for next time period.
	MOVF 0x4A,W
	MOVWF 0x01
; 476: End Proc
	RETURN
; 477: 
; 478: 
; 479: 
; 480: 
; 481: read_dht:
L0004:
; 482: 'Notes on the DHT22 and DHT11 Temp / Humidity sensors.
; 483: 'These 2 Sensors are made by the same Company and look very similar.
; 484: 'The DHT22 is the better of the 2 with better temp/humidity range and accuracy.Also is more expensive.
; 485: 'They both use an identical data format and can be decoded with the same code
; 486: 'but the meaning of the numbers returned is differant.
; 487: 'Each sensor sends 4, 8 bit data bytes followed by a 8 bit checksum.
; 488: 'For DHT11 data returned is simply 1st byte = Humidity, 2nd byte is always 0,3rd byte = temp, 4th byte always 0 , Chksum.
; 489: 'So if the data returned was 21,0,35,0 - chksum , this means Humidity is 21% and the Temp is 35D.
; 490: 
; 491: 'For DHT22 data returned is 16 bit number / 10 Humidity, 16 bit number / 10 temperature  -- chkcum.
; 492: 'So if the data returned is 1 1 2 4 - chksum , this means the Humidity is (256 * 1 + 1) /10 = 25.7% and the Temp is (256 * 2 + 4)/10 = 52.2D
; 493: 'Note that OS THGR810 Sensors dont send fractional part of the humidity reading,so this value is discarded.
; 494: 'Its doubtful whether is very accurate anyway.
; 495: 'This routine uses Timer0 to measure the pulse duration of the sensor, and the tick rate depends on the micro clock and the Timer0 prescaler value.
; 496: 'If the crystal is changed from 20 Mhz , the timer values will have to be changed also.
; 497: 
; 498: 
; 499: 
; 500: 'Read the DHT Sensor.
; 501: 
; 502: dht_error = 0
	BCF 0x49,2
; 503: 'We get here with the DHT data line high, which is the normal state when not reading.
; 504: dhtp = 0  'dht port  o/p
	BSF STATUS,RP0
	BCF 0x05,3
	BCF STATUS,RP0
; 505: dht = 0
	BCF 0x05,3
; 506: WaitMs 20  'send 20 ms low,,wait for DHT to respond
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 507: dhtp = 1  'porta i/p
	BSF STATUS,RP0
	BSF 0x05,3
	BCF STATUS,RP0
; 508: 
; 509: p1: If dht = 1 Then Goto p1  'skip next 3 pulses so we get to the first bit pulse.
L0005:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,3
	GOTO L0043
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0005
L0043:
; 510: p2: If dht = 0 Then Goto p2
L0006:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x05,3
	GOTO L0044
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0006
L0044:
; 511: p3: If dht = 1 Then Goto p3
L0007:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,3
	GOTO L0045
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0007
L0045:
; 512: 
; 513: For n = 0 To 4  '5 bytes to receive, 4 data bytes plus checksum byte.
	CLRF 0x4B
L0046:
	MOVF 0x4B,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0047
; 514: 	packet = 0
	CLRF 0x53
; 515: 
; 516: 	For packetbit = 1 To 8  '8 bits per data packet
	MOVLW 0x01
	MOVWF 0x7D
L0048:
	MOVF 0x7D,W
	SUBLW 0x08
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0049
; 517: 		packet = ShiftLeft(packet, 1)  'accumulate bits To make data Byte
	MOVF 0x53,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SL00
	MOVF R0L,W
	MOVWF 0x53
; 518: 
; 519: 		loop: If dht = 0 Then Goto loop  'Wait for high which is start of data bit.
L0008:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x05,3
	GOTO L0050
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0008
L0050:
; 520: 		TMR0 = 0  'clear timer0
	CLRF 0x01
; 521: 		loop1: If dht = 1 Then Goto loop1  'Wait for low which = end of data bit
L0009:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,3
	GOTO L0051
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0009
L0051:
; 522: 		'Timer0 counts in 3.2 us ticks, so we need to discriminate between 70 Us and 28 Us.
; 523: 		'16 = 50 us , approx 1/2 way between 28 and 70 us
; 524: 		If TMR0 > 16 Then  'Data 1 = pulse of 70 uS, data 0 = pulse of 28 uS.
	MOVF 0x01,W
	SUBLW 0x10
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0052
; 525: 			High packet.0  'Set bit 0 of packet to 1
	BSF 0x53,0
; 526: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0053
L0052:
; 527: 			Low packet.0  'set bit 0 of packet to 0
	BCF 0x53,0
; 528: 		Endif
L0053:
; 529: 	Next packetbit
	MOVLW 0x01
	ADDWF 0x7D,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0048
L0049:
; 530: tpacket(n) = packet
	MOVF 0x4B,W
	ADDLW 0x3D
	MOVWF FSR
	MOVF 0x53,W
	MOVWF INDF
; 531: Next n
	MOVLW 0x01
	ADDWF 0x4B,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0046
L0047:
; 532: chksm = (tpacket(0) + tpacket(1) + tpacket(2) + tpacket(3))
	MOVF 0x3D,W
	ADDWF 0x3E,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x3F,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x40,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x7F
; 533: If tpacket(4) <> chksm Then dht_error = 1  'last 8 bits of packet are checksum
	MOVF 0x41,W
	SUBWF 0x7F,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0054
	BSF 0x49,2
L0054:
; 534: 
; 535: 'The 5 data bytes are stored in the tpacket array,
; 536: 'DHT11 only has resolution of 1D and 1% RH, so we can ignore the fractional bytes (1 and 3) which are always 0.
; 537: If dht11 = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x49,3
	GOTO L0055
; 538: 	hum = tpacket(0)
	MOVF 0x3D,W
	MOVWF 0x4F
	CLRF 0x50
; 539: 	humidity2 = hum / 10
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x48
; 540: 	humidity1 = hum Mod 10
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x47
; 541: 	tmp1 = tpacket(2)
	MOVF 0x3F,W
	MOVWF 0x55
; 542: 	
; 543: 	tmp = averagetemp(tmp1)  'Gives temp averaged over 5 minutes * 10, done to make the output a little flatter.
	MOVF 0x55,W
	BSF STATUS,RP0
	MOVWF 0x33
	BCF STATUS,RP0
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
	BSF STATUS,RP0
	MOVF 0x3B,W
	BCF STATUS,RP0
	MOVWF 0x39
	BSF STATUS,RP0
	MOVF 0x3C,W
	BCF STATUS,RP0
	MOVWF 0x3A
; 544: 	temp3 = tmp / 100
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x46
; 545: 	temp2 = (tmp Mod 100) / 10
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x42,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x45
; 546: 	temp1 = (tmp Mod 100) Mod 10
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x42,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x44
; 547: 	tempsign = 0
	CLRF 0x4E
; 548: Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0056
L0055:
; 549: 	hum.HB = tpacket(0)
	MOVF 0x3D,W
	MOVWF 0x50
; 550: 	hum.LB = tpacket(1)
	MOVF 0x3E,W
	MOVWF 0x4F
; 551: 	tmp.HB = tpacket(2)
	MOVF 0x3F,W
	MOVWF 0x3A
; 552: 	tmp.LB = tpacket(3)
	MOVF 0x40,W
	MOVWF 0x39
; 553: 	If tmp.15 = 1 Then  'used to indicate negative temp, DHT22 can read from -40C to 80C, DHT11 from 0C to 80C
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3A,7
	GOTO L0057
; 554: 		tmp.15 = 0
	BCF 0x3A,7
; 555: 		tempsign = 8  'Set Temp sign for OS data
	MOVLW 0x08
	MOVWF 0x4E
; 556: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0058
L0057:
; 557: 		tempsign = 0
	CLRF 0x4E
; 558: 	Endif
L0058:
; 559: 
; 560: 	temp3 = tmp / 100  'Convert Temp readings to suit OS data format
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x46
; 561: 	temp2 = (tmp Mod 100) / 10
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x42,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x45
; 562: 	temp1 = (tmp Mod 100) Mod 10
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x42,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x44
; 563: 	humidity2 = hum / 100  'Convert Humidity readings to suit OS data format.
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x48
; 564: 	humidity1 = (hum Mod 100) / 10
	MOVF 0x4F,W
	MOVWF R0L
	MOVF 0x50,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x42,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x41
	BCF STATUS,RP0
	MOVF R0H,W
	BSF STATUS,RP0
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x47
; 565: 	
; 566: Endif
L0056:
; 567: 
; 568: If dht_error = 1 Then  'If we get here its most likely the battery is going flat.
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x49,2
	GOTO L0059
; 569: 	temp1 = 0
	CLRF 0x44
; 570: 	temp2 = 0
	CLRF 0x45
; 571: 	temp3 = 0
	CLRF 0x46
; 572: 	humidity1 = 0
	CLRF 0x47
; 573: 	humidity2 = 0
	CLRF 0x48
; 574: 	battflag = 0
	CLRF 0x74
; 575: Endif
L0059:
; 576: 'Hserout "Temp = ", #temp3, #temp2, ".", #temp1, CrLf
; 577: 
; 578: dhtpower = 0  'Turn off the DHT Sensor power to reduce battery drain.
	BCF 0x05,4
; 579: Return
	RETURN
; 580: 
; 581: Function averagetemp(avtemp As Byte) As Word
L0010:
; 582: 'Calculate rolling average for Temperature over 5 minutes.
; 583: 'Needed only for the DHT11 Sensor to make its output look a bit more realistic.
; 584: 'Fuction output is average Temp * 10 to avoid having to use floating point math as it takes too much memory.
; 585: 'So a temp of 23D will produce 230, 23.1 = 231 etc.
; 586: 
; 587: 
; 588: 	For x1 = 0 To 3
	CLRF 0x37
L0060:
	MOVF 0x37,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0061
; 589: 		x2 = 4 - x1
	MOVF 0x37,W
	SUBLW 0x04
	MOVWF 0x54
; 590: 		x3 = 3 - x1
	MOVF 0x37,W
	SUBLW 0x03
	MOVWF 0x75
; 591: 		avtemperature(x2) = avtemperature(x3)
	MOVF 0x75,W
	ADDLW 0xB5
	MOVWF FSR
	MOVF INDF,W
	MOVWF ARRARG_0
	MOVF 0x54,W
	ADDLW 0xB5
	MOVWF FSR
	MOVF ARRARG_0,W
	MOVWF INDF
; 592: 	Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0060
L0061:
; 593: 	avtemperature(0) = avtemp
	BSF STATUS,RP0
	MOVF 0x33,W
	MOVWF 0x35
; 594: 	avcount = 0
	CLRF 0x20
	CLRF 0x21
	BCF STATUS,RP0
; 595: 	For x1 = 0 To 4
	CLRF 0x37
L0062:
	MOVF 0x37,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0063
; 596: 	avcount = avcount + avtemperature(x1)
	BSF STATUS,RP0
	MOVF 0x20,W
	BCF STATUS,RP0
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x21,W
	BCF STATUS,RP0
	MOVWF R0H
	MOVF 0x37,W
	ADDLW 0xB5
	MOVWF FSR
	MOVF INDF,W
	MOVWF R1L
	CLRF R1H
	MOVF R0L,W
	ADDWF R1L,W
	BSF STATUS,RP0
	MOVWF 0x20
	BCF STATUS,RP0
	MOVF R0H,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF R1H,W
	BSF STATUS,RP0
	MOVWF 0x21
	BCF STATUS,RP0
; 597: 	Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
L0063:
; 598: 	averagetemp = avcount * 2
	BSF STATUS,RP0
	MOVF 0x20,W
	BCF STATUS,RP0
	MOVWF R3L
	BSF STATUS,RP0
	MOVF 0x21,W
	BCF STATUS,RP0
	MOVWF R3H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	BSF STATUS,RP0
	MOVWF 0x3B
	BCF STATUS,RP0
	MOVF R2H,W
	BSF STATUS,RP0
	MOVWF 0x3C
	BCF STATUS,RP0
; 599: End Function
	RETURN
; 600: 'This code provided by Weber from osngr.net
; 601: crc2calc:
L0011:
; 602: 'BASIC code to compute a CCITT-8 CRC checksum for a nibble-based message
; 603: 
; 604: crc = 0
	CLRF 0x35
; 605: crc = crcnibble(crc, sensorid1)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x77,W
	MOVWF 0x38
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 606: crc = crcnibble(crc, sensorid2)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x78,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 607: crc = crcnibble(crc, sensorid3)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x79,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 608: crc = crcnibble(crc, sensorid4)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x7A,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 609: crc = crcnibble(crc, channel)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x3C,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 610: crc = crcnibble(crc, rollingcode1)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x72,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 611: crc = crcnibble(crc, rollingcode2)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x73,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 612: crc = crcnibble(crc, battflag)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x74,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 613: crc = crcnibble(crc, temp1)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x44,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 614: crc = crcnibble(crc, temp2)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x45,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 615: crc = crcnibble(crc, temp3)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x46,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 616: crc = crcnibble(crc, tempsign)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x4E,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 617: crc = crcnibble(crc, humidity1)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 618: crc = crcnibble(crc, humidity2)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x48,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 619: crc = crcnibble(crc, unknown)
	MOVF 0x35,W
	MOVWF 0x36
	MOVF 0x7B,W
	MOVWF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 620: 
; 621: 'at the end, need to run 8 zero bits through to finish the calculation
; 622: 
; 623: crc = crcnibble(crc, 0)
	MOVF 0x35,W
	MOVWF 0x36
	CLRF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 624: crc = crcnibble(crc, 0)
	MOVF 0x35,W
	MOVWF 0x36
	CLRF 0x38
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0012
	MOVF 0x3B,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x35
; 625: 
; 626: crcnib1 = crc And 15
	MOVF 0x35,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	BSF STATUS,RP0
	MOVWF 0x27
	BCF STATUS,RP0
; 627: crcnib2 = ShiftRight(crc, 4)
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	CALL SR00
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x28
	BCF STATUS,RP0
; 628: 
; 629: 'now, "encode" these two nibbles after your crc1, crc2 checksum nibbles
; 630: 
; 631: Return
	RETURN
; 632: 'this function adds one more nibble to the crc calculation
; 633: 
; 634: Function crcnibble(crc As Byte, nibble As Byte) As Byte
L0012:
; 635: 
; 636: For bitno = 0 To 3
	CLRF 0x7E
L0064:
	MOVF 0x7E,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0065
; 637: 	If crc.7 = 1 Then  'does this return "1" or "8" ? might need "if crc.7 = 8" instead...
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x36,7
	GOTO L0066
; 638: 		'note: I assume that nibble.3 returns either "0" or "1"
; 639: 		'if it returns "0" or "8" instead then this code is not correct
; 640: 		'and you would need another IF statement here to OR a "1" into
; 641: 		'the left - shifted crc If Bit 3 of nibble is a one
; 642: 		crc = ShiftLeft(crc, 1)
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SL00
	MOVF R0L,W
	MOVWF 0x36
; 643: 		If nibble.3 = 1 Then crc = crc Or 1
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x38,3
	GOTO L0067
	MOVF 0x36,W
	MOVWF R0L
	MOVLW 0x01
	IORWF R0L,W
	MOVWF 0x36
L0067:
; 644: 		If nibble.3 = 0 Then crc = crc Or 0
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,3
	GOTO L0068
	MOVF 0x36,W
	MOVWF R0L
	MOVLW 0x00
	IORWF R0L,W
	MOVWF 0x36
L0068:
; 645: 		crc = crc Xor crcpoly
	MOVF 0x36,W
	MOVWF R0L
	BSF STATUS,RP0
	MOVF 0x26,W
	BCF STATUS,RP0
	XORWF R0L,W
	MOVWF 0x36
; 646: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0069
L0066:
; 647: 		'same comment as above -- depending on what "nibble.3" returns
; 648: 		crc = ShiftLeft(crc, 1)
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SL00
	MOVF R0L,W
	MOVWF 0x36
; 649: 		If nibble.3 = 1 Then crc = crc Or 1
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x38,3
	GOTO L0070
	MOVF 0x36,W
	MOVWF R0L
	MOVLW 0x01
	IORWF R0L,W
	MOVWF 0x36
L0070:
; 650: 		If nibble.3 = 0 Then crc = crc Or 0
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x38,3
	GOTO L0071
	MOVF 0x36,W
	MOVWF R0L
	MOVLW 0x00
	IORWF R0L,W
	MOVWF 0x36
L0071:
; 651: 
; 652: 	Endif
L0069:
; 653: 
; 654: 	nibble = ShiftLeft(nibble, 1)
	MOVF 0x38,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SL00
	MOVF R0L,W
	MOVWF 0x38
; 655: Next bitno
	MOVLW 0x01
	ADDWF 0x7E,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0064
L0065:
; 656: 
; 657: crcnibble = crc
	MOVF 0x36,W
	MOVWF 0x3B
; 658: 
; 659: End Function
	RETURN
; 660: calc_crc1:  'Calculate the first crc, simply the modulo8 sum of all the data variables.
L0013:
; 661: crc1calc = sensorid1 + sensorid2 + sensorid3 + sensorid4 + channel + rollingcode1 + rollingcode2 + battflag
	MOVF 0x77,W
	ADDWF 0x78,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x79,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x7A,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x3C,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x72,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x73,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x74,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x51
; 662: crc1calc = crc1calc + temp1 + temp2 + temp3 + tempsign + humidity1 + humidity2 + unknown
	MOVF 0x51,W
	ADDWF 0x44,W
	BSF STATUS,RP0
	MOVWF 0x41
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x45,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x46,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x4E,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x47,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x48,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	ADDWF 0x7B,W
	BSF STATUS,RP0
	MOVWF 0x41
	MOVF 0x42,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x42
	MOVF 0x41,W
	BCF STATUS,RP0
	MOVWF 0x51
; 663: crc1nib1 = crc1calc And 15  'Convert single byte into 2 nibbles.
	MOVF 0x51,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	BSF STATUS,RP0
	MOVWF 0x29
	BCF STATUS,RP0
; 664: crc1nib2 = ShiftRight(crc1calc, 4)
	MOVF 0x51,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SR00
	MOVF R0L,W
	BSF STATUS,RP0
	MOVWF 0x2A
	BCF STATUS,RP0
; 665: Return
	RETURN
; 666: 'Generate a random rumber for the rollingcode.
; 667: Function random_number(seed As Word, looptimes As Byte) As Byte
L0014:
; 668: For x1 = 1 To looptimes
	MOVLW 0x01
	MOVWF 0x37
L0072:
	MOVF 0x37,W
	SUBWF 0x7C,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0073
; 669: 	t1 = seed.0 Xor seed.2
	CLRW
	BTFSC 0x42,0
	ADDLW 0x01
	BTFSC 0x42,2
	XORLW 0x01
	BTFSC STATUS,Z
	BCF 0x49,4
	BTFSS STATUS,Z
	BSF 0x49,4
; 670: 	t2 = t1 Xor seed.3
	CLRW
	BTFSC 0x49,4
	ADDLW 0x01
	BTFSC 0x42,3
	XORLW 0x01
	BTFSC STATUS,Z
	BCF 0x49,5
	BTFSS STATUS,Z
	BSF 0x49,5
; 671: 	t3 = t2 Xor seed.5
	CLRW
	BTFSC 0x49,5
	ADDLW 0x01
	BTFSC 0x42,5
	XORLW 0x01
	BTFSC STATUS,Z
	BCF 0x49,6
	BTFSS STATUS,Z
	BSF 0x49,6
; 672: 	seed = ShiftRight(seed, 1)
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	CALL SR00
	MOVF R0L,W
	MOVWF 0x42
	MOVF R0H,W
	MOVWF 0x43
; 673: 	seed.15 = t3
	BTFSC 0x49,6
	BSF 0x43,7
	BTFSS 0x49,6
	BCF 0x43,7
; 674: 	random_number = seed.LB
	MOVF 0x42,W
	BSF STATUS,RP0
	MOVWF 0x34
	BCF STATUS,RP0
; 675: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
L0073:
; 676: End Function
	RETURN
; 677: 
; End of program
;       PAGE SELECT
;	BCF PCLATH,3
L0074:	GOTO L0074
; End of listing
	END
